<?php
/**
 * <pre>
 * Advanced Tags & Prefixes
 * IP.Board v3.2.2
 * Last Updated: 12 September, 2011
 * </pre>
 *
 * @author 		Ryan Hoerr
 * @copyright	(c) 2011 Ryan Hoerr / Sublime Development
 * @link		http://www.sublimism.com
 * @version		2.0.5 (Revision 20007)
 */

/**
 * Add a Prefixes tab to forum settings.
 */

if ( ! defined( 'IN_IPB' ) ) {
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

IPSDebug::fireBug( 'info', array( 'Loaded admin_forum_form__advancedtagsprefixes' ) );

class admin_forum_form__advancedtagsprefixes
{
	protected $registry;
	protected $DB;
	protected $settings;
	protected $request;
	protected $lang;
	protected $tag_modes;
	
	public function __construct()
	{
		$this->registry		= ipsRegistry::instance();
		$this->DB			= $this->registry->DB();
		$this->settings		= $this->registry->settings();
		$this->request  	=& $this->registry->fetchRequest();
		$this->lang			= $this->registry->getClass('class_localization');
		$this->lang->loadLanguageFile( array( 'admin_global' ), 'advancedtagsprefixes' );

		$this->tag_modes = array(	array( 'inherit', $this->lang->words['pre_tag_inherit'] ),
									array( 'open', $this->lang->words['pre_tag_open'] ),
									array( 'closed', $this->lang->words['pre_tag_closed'] ),
									array( 'prefix', $this->lang->words['pre_tag_prefix'] ) );
	}
	
	public function getDisplayContent( $data, $tabs )
	{
		/**
		 * Display only for non-redirect forums
		 */
		if( $data['redirect_on'] ) {
			return array(	'tabs'		=> '',
							'content'	=> '',
							'tabsUsed'	=> 0 );
		}
		
		/**
		 * Fetch prefix data
		 */
		$this->DB->build( array(	'select'	=> '*',
									'from'		=> 'topic_prefixes',
									'order'		=> 'prefix_title asc' ) );
		$this->DB->execute();
		while( $r = $this->DB->fetch() ) {
			$prefixes[ IPSText::mbstrtolower( $r['prefix_title'] ) ] = $r;
		}
		
		$prefix_list = explode( ',', $data['tag_predefined'] );
		$prefix_form = array();
		
		sort( $prefix_list );
		
		foreach( $prefix_list as $k => $prefix ) {
			if( $p = $prefixes[ IPSText::mbstrtolower( trim($prefix) ) ] ) {
				$prefix_list[ $k ]	= $p['prefix_pre'] . ($p['prefix_showtitle'] ? $p['prefix_title'] : '') . $p['prefix_post'];
				$prefix_form[]		= array( trim( IPSText::safeslashes( $prefix ) ), $p['prefix_title'] );
			}
			else {
				unset( $prefix_list[ $k ] );
			}
		}
		
		if( count( $prefix_list ) ) {
			$prefix_list	= implode( ' ', $prefix_list );
		}
		else {
			$prefix_list	= $this->lang->words['pre_none'] . ' <a href="'.$this->settings['_base_url'].'app=advancedtagsprefixes" class="mini_button">'.$this->lang->words['pre_manage'].'</a>';
		}
		
		/**
		 * Build the prefix form
		 */
		$form				= array();
		$form['required']	= $this->registry->output->formYesNo( "require_prefix", $data['require_prefix'] );
		$form['show_prefix_in_desc'] = $this->registry->output->formYesNo( "show_prefix_in_desc", $data['show_prefix_in_desc'] );
		$form['tag_mode']	= $this->registry->output->formDropdown( "tag_mode", $this->tag_modes, $data['tag_mode'] );

		array_unshift( $prefix_form, array('', $this->lang->words['pre_none']) );
		$form['default']	= $this->registry->output->formDropdown( "default_prefix", $prefix_form, $data['default_prefix'] );
		$form['default_tags'] = $this->registry->output->formInput( "default_tags", $data['default_tags'] );
		
		$tab = $tabs+1;
		$content = <<<HTML
	<div id='tab_FORUMS_{$tab}_content'>
		<table class='ipsTable double_pad'>
			<tr>
				<th colspan="2">
					{$this->lang->words['pre_app_title']}
				</th>
			</tr>
			<tr>
				<td colspan="2">
					{$this->lang->words['pre_forum_settings_head']} <a href="{$this->settings['_base_url']}app=advancedtagsprefixes" class='mini_button'>{$this->lang->words['pre_manage']}</a>
				</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_current']}</strong></td>
				<td>{$prefix_list}</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_tag_mode']}</strong></td>
				<td>
					{$form['tag_mode']}<br />
					<span class="desctext">{$this->lang->words['pre_tag_mode_desc']}</span>
				</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_default']}</strong></td>
				<td class='field_field'>
					{$form['default']}<br />
					<span class="desctext">{$this->lang->words['pre_default_desc']}</span>
				</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_default_tags']}</strong></td>
				<td class='field_field'>
					{$form['default_tags']}<br />
					<span class="desctext">{$this->lang->words['pre_default_tags_desc']}</span>
				</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_require']}</strong></td>
				<td class='field_field'>
					{$form['required']}<br />
					<span class="desctext">{$this->lang->words['pre_require_desc']}</span>
				</td>
			</tr>
			<tr>
				<td class='field_title'><strong class='title'>{$this->lang->words['pre_show_in_desc']}</strong></td>
				<td class='field_field'>
					{$form['show_prefix_in_desc']}<br />
					<span class="desctext">{$this->lang->words['pre_show_in_desc_desc']}</span>
				</td>
			</tr>
		</table>
	</div>
HTML;
		
		return array(	'tabs'		=> "<li id='tab_FORUMS_{$tab}' class=''>{$this->lang->words['pre_app_title']}</li>",
						'content'	=> $content,
						'tabsUsed'	=> 1 );
	}
	
	public function getForSave()
	{
		return array(	'default_prefix'		=> IPSText::safeslashes($this->request['default_prefix']),
						'default_tags'			=> IPSText::safeslashes($this->request['default_tags']),
						'require_prefix'		=> intval($this->request['require_prefix']),
						'tag_mode'				=> in_array( $this->request['tag_mode'], array_keys( $this->tag_modes ) ) ? $this->request['tag_mode'] : 'inherit',
						'show_prefix_in_desc'	=> intval($this->request['show_prefix_in_desc']) );
	}
}
